<?php
require_once __DIR__ . '/../models/Income.php';
require_once __DIR__ . '/../models/Expense.php';
class DashboardController {
    public function index() {
        if (!isset($_SESSION['user'])) { header('Location: index.php?controller=auth&action=login'); exit; }
        $incomeModel = new Income();
        $expenseModel = new Expense();
        $month = $_GET['month'] ?? date('m');
        $year = $_GET['year'] ?? date('Y');
        $incomes = $incomeModel->getByMonthYear($month, $year);
        $expenses = $expenseModel->getByMonthYear($month, $year);
        $incomeSum = array_sum(array_column($incomes, 'amount'));
        $expenseSum = array_sum(array_column($expenses, 'amount'));
        include __DIR__ . '/../views/dashboard/index.php';
    }
}
?>