<?php
require_once __DIR__ . '/../models/Income.php';
require_once __DIR__ . '/../models/Expense.php';

class ReportController {

    // public function balancesheet() {
    //     $incModel = new Income();
    //     $expModel = new Expense();
    //     $incomes = $incModel->getTotalIncome();      // You can create this function
    //     $expenses = $expModel->getTotalExpense();    // Create this too
    //     $balance = $incomes - $expenses;
    //     include __DIR__ . '/../views/reports/balance_sheet.php';
    // }
public function balancesheet() {
    $incModel = new Income();
    $expModel = new Expense();
    $income = $incModel->getTotalIncome();
    $expense = $expModel->getTotalExpense();
    $balance = $income - $expense;

    // Capture view output into $content
    ob_start();
    include __DIR__ . '/../views/reports/balance_sheet.php';
    $content = ob_get_clean();

    include __DIR__ . '/../views/layout.php';
}

    public function monthwise() {
            $year = $_GET['year'] ?? date('Y');
    $month = $_GET['month'] ?? 'all';

    $incModel = new Income();
    $expModel = new Expense();
    $data = [];

    if ($month == 'all') {
        // all months
        for ($m=1; $m<=12; $m++) {
            $income = $incModel->getByMonthYear($m, $year, true);
            $expense = $expModel->getByMonthYear($m, $year, true);
            $data[] = [
                'month'=>$m,
                'income'=>$income,
                'expense'=>$expense,
                'balance'=>$income-$expense
            ];
        }
    } else {
        // specific month
        $m = (int)$month;
        $income = $incModel->getByMonthYear($m, $year, true);
        $expense = $expModel->getByMonthYear($m, $year, true);
        $data[] = [
            'month'=>$m,
            'income'=>$income,
            'expense'=>$expense,
            'balance'=>$income-$expense
        ];
    }
        // Capture view output into $content
    ob_start();
        include __DIR__ . '/../views/reports/month_wise.php';
            $content = ob_get_clean();

    include __DIR__ . '/../views/layout.php';
    }

    public function export_csv() {
    $type = $_GET['type'] ?? 'monthwise';
    $year = $_GET['year'] ?? date('Y');
    $month = $_GET['month'] ?? 'all';

    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="' . $type . '_report.csv"');

    $output = fopen('php://output', 'w');

    if ($type=='balancesheet') {
        $inc = new Income(); $exp = new Expense();
        $income = $inc->getTotalIncome();
        $expense = $exp->getTotalExpense();
        $balance = $income - $expense;

        fputcsv($output, ['Total Income', $income]);
        fputcsv($output, ['Total Expense', $expense]);
        fputcsv($output, ['Net Balance', $balance]);

    } else if ($type=='monthwise') {
        fputcsv($output, ['Month','Income','Expense','Balance']);
        $inc = new Income(); $exp = new Expense();

        if ($month=='all') {
            for($m=1;$m<=12;$m++){
                $income = $inc->getByMonthYear($m,$year,true);
                $expense = $exp->getByMonthYear($m,$year,true);
                fputcsv($output, [date("F", mktime(0,0,0,$m,10)),$income,$expense,$income-$expense]);
            }
        } else {
            $m=(int)$month;
            $income = $inc->getByMonthYear($m,$year,true);
            $expense = $exp->getByMonthYear($m,$year,true);
            fputcsv($output, [date("F", mktime(0,0,0,$m,10)),$income,$expense,$income-$expense]);
        }
    }
    fclose($output);
    exit;
}

}
?>
