<?php ob_start(); ?>
<div class="card">
  <h2>Edit Expense</h2>
  <?php if(!empty($errors)) foreach($errors as $e) echo '<p class="error">'.htmlspecialchars($e).'</p>'; ?>
  <form method="post" onsubmit="return validateMoneyForm(this)">
    <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
    <div class="form-row">
      <div class="field"><label>Name</label><input name="apartment" class="form-control form-control-lg" value="<?=htmlspecialchars($_POST['apartment'] ?? $expense['apartment'])?>"></div>
      <div class="field"><label>Amount</label><input name="amount" type="number" class="form-control" step="0.01" value="<?=htmlspecialchars($_POST['amount'] ?? $expense['amount'])?>" required></div>
    </div>
    <div class="form-row">
      <div class="field"><label>Category</label><input name="category" class="form-control form-control-lg" value="<?=htmlspecialchars($_POST['category'] ?? $expense['category'])?>"></div>
      <div class="field"><label>Date</label><input name="date" type="date" class="form-control" value="<?=htmlspecialchars($_POST['date'] ?? $expense['date'])?>" required></div>
    </div>
    <div class="form-row"><div class="field"><label>Note</label><textarea name="note"><?=htmlspecialchars($_POST['note'] ?? $expense['note'])?></textarea></div></div>
    <div style="margin-top:12px"><button type="submit" class="btn btn-primary">Update</button> <a href="index.php?controller=expense&action=index" class="btn btn-secondary">Cancel</a></div>
  </form>
</div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
