<?php ob_start(); ?>
<div class="card">
  <h2>Add Income</h2>
  <?php if(!empty($errors)) foreach($errors as $e) echo '<p class="error">'.htmlspecialchars($e).'</p>'; ?>
  <?php if(!empty($msg)) echo '<p class="success">'.htmlspecialchars($msg).'</p>'; ?>
  <form method="post" onsubmit="return validateMoneyForm(this)">
    <input type="hidden" name="csrf" value="<?php echo htmlspecialchars(csrf_token()); ?>">
    <div class="form-row">
      <div class="field"><label>Apartment</label><input name="apartment" value="<?=htmlspecialchars($_POST['apartment'] ?? '')?>" class="form-control form-control-lg"></div>
      <div class="field"><label>Amount</label><input name="amount" type="number" step="0.01" value="<?=htmlspecialchars($_POST['amount'] ?? '')?>" required  class="form-control"></div>
    </div>
    <div class="form-row">
      <div class="field"><label>Category</label><input name="category" value="<?=htmlspecialchars($_POST['category'] ?? '')?>"  class="form-control form-control-lg"></div>
      <div class="field"><label>Date</label><input name="date" type="date" value="<?=htmlspecialchars($_POST['date'] ?? date('Y-m-d'))?>" required  class="form-control"></div>
    </div>
    <div class="form-row"><div class="field"><label>Note</label><textarea name="note" class="form-control"><?=htmlspecialchars($_POST['note'] ?? '')?></textarea></div></div>
    <div style="margin-top:12px"><button type="submit" class="btn btn-primary">Save</button> <a href="index.php?controller=income&action=index" class="btn btn-secondary">Cancel</a></div>
  </form>
</div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
