<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Apartment Manager</title>
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="assets/bootstrap/css/bootstrap.min.css"></head>
  <script src="assets/validate.js"></script>
  <style>
    /* Dropdown menu styling */
    .nav ul { list-style: none; margin: 0; padding: 0; display: flex; }
    .nav ul li { position: relative; margin-right: 10px; }
    .nav ul li a { color: #000; text-decoration: none; padding: 8px 12px; display: block; }
    .nav ul li ul.dropdown { display: none; position: absolute; top: 100%; left: 0; background: #007BFF; min-width: 150px; }
    .nav ul li:hover ul.dropdown { display: block; }
    .nav ul li ul.dropdown li { margin: 0; }
    .nav ul li ul.dropdown li a { padding: 8px 12px; background: #0056b3; }
    .nav ul li ul.dropdown li a:hover { background: #003f7f; }
  </style>
</head>
<body>
<header class="header">
  <div class="container header-inner">
    <h1 class="brand">Apartment Manager</h1>
    <nav class="nav">
      <?php if(isset($_SESSION['user'])): ?>
        <ul>
          <li><a href="index.php?controller=dashboard&action=index">Dashboard</a></li>
          <li><a href="index.php?controller=income&action=index">Incomes</a></li>
          <li><a href="index.php?controller=expense&action=index">Expenses</a></li>
          <li><a href="index.php?controller=user&action=index">Users</a></li>
          <li>
            <a href="#">Reports &#9662;</a>
            <ul class="dropdown">
              <li><a href="index.php?controller=report&action=balancesheet">Balance Sheet</a></li>
              <li><a href="index.php?controller=report&action=monthwise">Month-wise</a></li>
            </ul>
          </li>
          <li><a href="index.php?controller=auth&action=logout" class="btn-ghost">Logout</a></li>
        </ul>
      <?php endif; ?>
    </nav>
  </div>
</header>
<main class="container main">
  <?php echo $content; ?>
</main>
<footer class="footer">
  <div class="container">© Apartment Manager</div>
</footer>
</body>
</html>
