<?php ob_start(); ?>
<div class="card">
  <div class="toolbar"><h2>Monthly Report - <?=htmlspecialchars($year.'-'.str_pad($month,2,'0',STR_PAD_LEFT))?></h2>
    <div>
      <a href="index.php?controller=report&action=monthly&month=<?=$month?>&year=<?=$year?>&format=csv" class="btn-secondary">Download CSV</a>
      <button onclick="window.print()">Print / Save as PDF</button>
    </div>
  </div>
  <h3>Incomes</h3>
  <table class="table"><thead><tr><th>Date</th><th>Apartment</th><th>Category</th><th>Amount</th><th>Note</th></tr></thead><tbody>
    <?php foreach($incomes as $r): ?>
      <tr><td><?=htmlspecialchars($r['date'])?></td><td><?=htmlspecialchars($r['apartment'])?></td><td><?=htmlspecialchars($r['category'])?></td><td><?=number_format($r['amount'],2)?></td><td><?=htmlspecialchars($r['note'])?></td></tr>
    <?php endforeach; ?>
  </tbody></table>
  <h3 style="margin-top:16px">Expenses</h3>
  <table class="table"><thead><tr><th>Date</th><th>Apartment</th><th>Category</th><th>Amount</th><th>Note</th></tr></thead><tbody>
    <?php foreach($expenses as $r): ?>
      <tr><td><?=htmlspecialchars($r['date'])?></td><td><?=htmlspecialchars($r['apartment'])?></td><td><?=htmlspecialchars($r['category'])?></td><td><?=number_format($r['amount'],2)?></td><td><?=htmlspecialchars($r['note'])?></td></tr>
    <?php endforeach; ?>
  </tbody></table>
</div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
